#!/usr/bin/env bash
set -euo pipefail

HERE="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SRC="${HERE}/RustDesk2.toml"

if [[ ! -f "$SRC" ]]; then
  echo "ERRO: RustDesk2.toml não encontrado ao lado deste ficheiro."
  exit 1
fi

DEST_DIR="/.config/stratechnaremote"
mkdir -p "$DEST_DIR"

cp -f "$SRC" "${DEST_DIR}/RustDesk2.toml"
echo "OK: Config aplicada em ${DEST_DIR}/RustDesk2.toml"

chmod +x "${HERE}/StratechnaRemote.AppImage" 2>/dev/null || true
"${HERE}/StratechnaRemote.AppImage" >/dev/null 2>&1 &
